' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa ContentBase okrela the oglne zachowanie jednostek treci na stronie www takich jak Product i Download.
''' Te klasy dziedzicz z ContentBase i dlatego nie potrzebuj wicej okrela oglnego zachowania zdefiniowanego w tej klasie.
''' </summary>
''' <remarks>Ta klasa ma oznaczenie MustInherit, wic jej egzemplarze nie mog by tworzone bezporednio.</remarks>
Public MustInherit Class ContentBase

#Region "Zmienne prywatne"

  Private _id As Integer = -1
  Private _title As String = String.Empty
  Private _description As String = String.Empty
  Private _categoryId As Integer = -1

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Konstruktor domylny
  ''' </summary>
  Public Sub New()

  End Sub

  ''' <summary>
  ''' Tworzy nowy egzemplarz ContentBase i ustawia jego wewnetrzny identyfikator.
  ''' </summary>
  Public Sub New(ByVal id As Integer)
    _id = id
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Definiuje metod Save dla kadej z klas potomnych ContentBase.
  ''' </summary>
  ''' <remarks></remarks>
  Public MustOverride Sub Save()

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca identyfikator jednostki treci w bazie danych.
  ''' </summary>
  Public ReadOnly Property Id() As Integer
    Get
      Return _id
    End Get
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia nazw jednostki treci w bazie danych.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _title
    End Get
    Set(ByVal value As String)
      _title = value
    End Set
  End Property

  ''' <summary>
  ''' Pobier lub ustawia opis (gwny tekst) jednostki treci w bazie danych.
  ''' </summary>
  Public Property Description() As String
    Get
      Return _description
    End Get
    Set(ByVal value As String)
      _description = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia w bazie danych identyfikator kategorii, do ktrej nalezy jednostka treci.
  ''' </summary>
  Public Property CategoryId() As Integer
    Get
      Return _categoryId
    End Get
    Set(ByVal value As Integer)
      _categoryId = value
    End Set
  End Property
#End Region

End Class
